<?php
/**
 * Created by PhpStorm.
 * User: Omen
 * Date: 2/7/2024
 * Time: 12:13 AM
 */

namespace App\Notifications;


use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;

class RegisterGreenUser extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $name;
    public $payment_method;
    public $registarion_id;
    public function __construct($name,$payment_method,$registarion_id)
    {
        //
        $this->name = $name;
        $this->payment_method = $payment_method;
        $this->registarion_id = $registarion_id;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage())
            ->from('info@thetruckingnetwork.ca',  'Green Freight Summit 2024')
//            ->cc('waqaramjad04@gmail.com')
            ->subject('Green Freight Summit Registration Confirmation')
            ->view('emails.green-email',['name'=> $this->name,
                'banner' => $this->payment_method == 'Paypal' ? 'fes-bannner-1.png' : 'fes-bannner-2.png',
                'content' => new HtmlString('Thank you for your registration to participate in Green Freight Summit Toronto 2024.<br><br>'. ($this->payment_method == 'Paypal' ? 'The event details are below with your event ticket clickable link.' : 'You will receive registration confirmation email once your payment is successful')),
                'fleet_url' => $this->payment_method == 'Paypal' ?  'https://greenfreightinnovation.ca/ticket/'.$this->registarion_id : null,
                'email' => null,
                'phone' => null,
                'payment_method' => $this->payment_method,
                'type' => 'user']);
    }


    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}