<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;

class RegisterFleetUser extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $name;
    public $payment_method;
    public $registarion_id;
    public $attendees_number;
    public function __construct($name,$payment_method,$attendees_number,$registarion_id)
    {
        //
        $this->name = $name;
        $this->payment_method = $payment_method;
        $this->registarion_id = $registarion_id;
        $this->attendees_number = $attendees_number;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->from('info@thetruckingnetwork.ca',  'Fleet Executive Summit 2024')
            ->cc('nav@thetruckingnetwork.ca')
            ->subject('Fleet Executive Summit Registration Confirmation')
            ->view('emails.fleet-email',['name'=> $this->name,
                'banner' => $this->payment_method == 'Paypal' ? 'fes-bannner-1.png' : 'fes-bannner-2.png',
                'content' => new HtmlString('Thank you for registering for Fleet Executive Summit Toronto 2024 November 27, 2024<br><br>'. ($this->payment_method == 'Paypal' ? 'Your registration is confirmed, and we look forward to your participation. You can view the event agenda <a href=`https://fleetexecsummit.net/?HomeSection=agenda`>here</a>. Additional details will be provided soon.<br>If you have any questions, please feel free to reach out' : 'You will receive registration confirmation email once your payment is successful  and we look forward to your participation. You can view the event agenda <a href=`https://fleetexecsummit.net/?HomeSection=agenda`>here</a>. Additional details will be provided soon.<br>If you have any questions, please feel free to reach out')),
                'fleet_url' => $this->payment_method == 'Paypal' ?  'https://fleetexecsummit.net/ticket/'.$this->registarion_id : null,
                'email' => null,
                'phone' => null,
                'attendees_number' => $this->attendees_number,
                'payment_method' => $this->payment_method,
                'type' => 'user']);
    }


    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
