<?php
/**
 * Created by PhpStorm.
 * User: Omen
 * Date: 6/25/2023
 * Time: 11:54 PM
 */

namespace App\Notifications;


use Hamcrest\Core\HasToString;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;


class NewJobApplicationSubmission extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $personal_name;
    public $personal_email;
    public $personal_mobile_number;
    public $job_id;
    public $job_title;
    public $posted_by_name;
    public $company_name;

    public function __construct($job_id,$job_title,$company_name)
    {
        //

        $this->job_id = $job_id;
        $this->job_title = $job_title;
        $this->company_name = $company_name;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage())
            -> from('info@thetruckingnetwork.ca','New Job Application')
            ->greeting('Hi '.$this->posted_by_name)
            ->line(New HtmlString('Your application to <strong>'.$this->job_title.'</strong>'.' at <strong>'.$this->company_name.'</strong> has been submitted'))
            ->line('Please login to BusinessPages360 in few days and check your job application status')
            ->line('We highly appreciate your interest in BusinessPages360!')
            ->action('View Job', url(config('APP_URL').'jobs/details/'.$this->job_id));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}