<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\FleetRegistration;
use App\Models\GreenRegistration;
use App\Notifications\NotifyFleetAdmin;
use App\Notifications\NotifyGreenAdmin;
use App\Notifications\RegisterFleetUser;
use App\Notifications\RegisterGreenUser;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use  PDO;

use Illuminate\Support\Facades\Notification;
use App\Models\User;
use Illuminate\Validation\Rules;
use Illuminate\Support\Facades\Hash;

class AccountController extends Controller
{ 
    public function getUserProfile($id)
    {

        $user = User::find($id);

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_profile_meta()');

        $stmt->execute();

        $cities = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $states = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $roles = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        return response()->json(
        [
            'user' => $user,
            'cities' => $cities,
            'states' => $states,
            'roles' => $roles
        ],200,[], JSON_NUMERIC_CHECK);
    }

    public function updateUserProfile(Request $request,$id)
    {

        $company_logo_base64_code = $request->input('company_logo_base64_code');

        $user = User::find($id);


           $user->first_name = $request->input('first_name'); 
           $user->last_name = $request->input('last_name'); 
           $user->username =  $request->input('first_name').' '. $request->input('last_name');
           $user->company_name = $request->input('company_name');
           $user->title = $request->input('title');
           $user->address_1 = $request->input('address_1');
           $user->address_2 = $request->input('address_2');
           $user->city = $request->input('city');
           $user->city1 = $request->input('city1');
           $user->state = $request->input('state');  
           $user->state1 = $request->input('state1');  
           $user->country = $request->input('country');
           $user->postal_code = $request->input('postal_code'); 
           $user->phone_number = $request->input('phone_number'); 
           $user->email = $request->input('email');

           $user->save();

           if($request->roles && sizeof($request->roles) > 0)
             $user->roles()->attach($request->roles);


        $user_folder_path = $user->id.'_'.str_replace('-','_',str_replace(' ','_',$user->username)).'/';

        $folder_path =  'public/uploads/businessattachments/' . $user_folder_path ;

        if($company_logo_base64_code != null)
        {

            if($request->input('id') != null)
            {
                Storage::disk('local')->delete('public/'.$user->company_logo_url);
            }

            preg_match("/data:image\/(.*?);/", $company_logo_base64_code, $file_extension);
            @list($type, $file_data) = explode(';', $company_logo_base64_code);
            @list(, $file_data) = explode(',', $file_data);


            $fileName = 'file_' . time() . '_' . rand(pow(10, 3 - 1), pow(10, 3) - 1) . '.' . $file_extension[1];

            Storage::disk('local')->put($folder_path.'logo/'. $fileName, base64_decode($file_data));

            $user->company_logo_url ='uploads/businessattachments/' .$user_folder_path. 'logo/'.$fileName;

            $user->save();
        }

           return response()->json(['Sucsess' => 'updated'],200);
    }

    public function getProfileMeta($user_id)
    {
        $user = User::find($user_id);

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_profile_meta()');

        $stmt->execute();

        $cities = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $states = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $roles = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');


        return response()->json(
            [
                'cities' => $cities,
                'states' => $states,
                'roles' => $roles,
                'user' => $user
            ],200,[], JSON_NUMERIC_CHECK);
    }


    public function deleteUserProfile($id)
    {

        $user = User::find($id);

        $user->delete();

        return response()->json(['Success' => 'Deleted'],200);
    }

    public function changePassword(Request $request,$id)
    {
        $user = User::find($id);

        $request->validate([
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        if(Hash::check($request->input('old_password'),$user->password))
        {
            $user->password = Hash::make($request->input('password'));

            $user->save();

            return response()->json(['Success' => 'Password Changed'],200);
        }
        else
        {
            return response()->json(['error' => 'password not match'],403);
        }

    }

    public function getUserPackageDetails($user_id)
    {
        $user = User::find($user_id);

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_user_package(?)');

        $stmt->execute(array($user->id));

        $user_package = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $user_package = sizeof($user_package) > 0  ? $user_package[0] : null;

        if($user_package != null)
        {
            $user_package->remaining_days = (int)$user_package->remaining_days;
            $user_package->no_of_businesses = (int)$user_package->no_of_businesses;
            $user_package->no_of_jobs = (int)$user_package->no_of_jobs;

            $user_package->no_of_categories_per_business = (int)$user_package->no_of_categories_per_business;
            $user_package->no_of_photos_per_business = (int)$user_package->no_of_photos_per_business;
            $user_package->is_video_available = (boolean)$user_package->is_video_available;
            $user_package->is_featured_available = (boolean)$user_package->is_featured_available;
            $user_package->is_contact_form_available = (boolean)$user_package->is_contact_form_available;
            $user_package->is_deleted = (boolean)$user_package->is_deleted;
            $user_package->validity = (int)$user_package->validity;
            $user_package->user_id = (int)$user_package->user_id;

        }

        $stmt->nextRowset();

        $package_detail = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

        $package_detail = $package_detail[0];

        $package_detail->is_valid = (int) $package_detail->is_valid;
        $package_detail->no_of_businesses = (int) $package_detail->no_of_businesses;
        $package_detail->no_of_jobs = (int) $package_detail->no_of_jobs;

        $package = new \stdClass();
        $package->user_package = $user_package;
        $package->package_details = $package_detail;

        return response()->json(['package_wrapper' => $package,[], JSON_NUMERIC_CHECK],200);
    }

    public function saveFleetUser(Request $request)
    {
//        Notification::send([$request->email],new RegisterFleetUser());
//        Notification::send(['waqaramjad04@gmail.com'],new NotifyFleetAdmin());

        $register = new FleetRegistration();

        $register->title = $request->input('title');
        $register->first_name = $request->input('first_name');
        $register->last_name = $request->input('last_name');
        $register->company_name = $request->input('company_name');
        $register->company_website = $request->input('company_website');
        $register->designation = $request->input('designation');
        $register->phone = $request->input('phone');
        $register->email = $request->input('email');
        $register->address1 = $request->input('address1');
        $register->address2 = $request->input('address2');
        $register->city = $request->input('city');
        $register->state = $request->input('state');
        $register->country = $request->input('country');
        $register->postal_code = $request->input('postal_code');
        $register->attendees_number = $request->input('attendees_number') + ($request->input('more_attendees') == true && $request->input('attendees_number') < 6 ? 1 : 0);
        $register->price = $request->input('price');
        $register->total_price = $request->input('total_price');
        $register->comments = $request->input('comments');

        $register->hst = 0.13;
        $register->total_amount = $request->input('total_amount');
        $register->location = $request->input('location');
        $register->payment_method = $request->input('payment_method');
        $register->contact_phone = $request->input('contact_phone');
        $register->contact_email = $request->input('contact_email');
        try{
            $register->save();
        }
        catch(\Exception $e)
        {
                dd($e);
        }


        $title = $register->title == 'Other' ? '' : $register->title;

        $registarion_id = Crypt::encryptString($register->id);

        if($register->payment_method == 'Paypal')
        {
            $email = $register->email;
            $phone = $register->phone;
        }
        else
        {
            $email = $register->contact_email;
            $phone = $register->contact_phone;
        }

//        try
//        {
            Notification::route('mail', $request->email)->notify(new RegisterFleetUser($register->title.' '.$register->first_name.' '.$register->last_name, $register->payment_method,$register->attendees_number, $registarion_id));

            Notification::route('mail','info@thetruckingnetwork.ca')->notify(new NotifyFleetAdmin($email,$phone,$register->payment_method,$register->first_name,$register->last_name,$register->company_name,$register->designation,$register->comments,$register->attendees_number,$registarion_id));
//        }
//        catch (\Exception $e)
//        {
//
//        }



        return response()->json(['success' => 'Notified', 'id' => $registarion_id],200);
    }

    public function getEventDetails($id)
        {
            $decrypted = Crypt::decryptString($id);

            $register = FleetRegistration::find($decrypted);

            return response()->json(['register' => $register],200);
        }

    public function saveGreenFreightUser(Request $request)
    {
        $register = new GreenRegistration();

        $register->title = $request->input('title');
        $register->first_name = $request->input('first_name');
        $register->last_name = $request->input('last_name');
        $register->company_name = $request->input('company_name');
        $register->company_website = $request->input('company_website');
        $register->designation = $request->input('designation');
        $register->phone = $request->input('phone');
        $register->email = $request->input('email');
        $register->address1 = $request->input('address1');
        $register->address2 = $request->input('address2');
        $register->city = $request->input('city');
        $register->state = $request->input('state');
        $register->country = $request->input('country');
        $register->postal_code = $request->input('postal_code');
        $register->attendees_number = $request->input('attendees_number') + ($request->input('more_attendees') == true && $request->input('attendees_number') < 6 ? 1 : 0);
        $register->price = $request->input('price');
        $register->total_price = $request->input('total_price');
        $register->comments = $request->input('comments');

        $register->hst = 0.13;
        $register->total_amount = $request->input('total_amount');
        $register->location = $request->input('location');
        $register->payment_method = $request->input('payment_method');
        $register->contact_phone = $request->input('contact_phone');
        $register->contact_email = $request->input('contact_email');
        try{
            $register->save();
        }
        catch(\Exception $e)
        {

        }


        $title = $register->title == 'Other' ? '' : $register->title;

        $registarion_id = Crypt::encryptString($register->id);

        if($register->payment_method == 'Paypal')
        {
            $email = $register->email;
            $phone = $register->phone;
        }
        else
        {
            $email = $register->contact_email;
            $phone = $register->contact_phone;
        }

        try
        {

            Notification::route('mail', $request->email)->notify(new RegisterGreenUser($register->title.' '.$register->first_name.' '.$register->last_name, $register->payment_method, $registarion_id));

            Notification::route('mail','info@thetruckingnetwork.ca')->notify(new NotifyGreenAdmin($email,$phone,$register->payment_method,$register->first_name,$register->last_name,$register->company_name,$register->designation,$register->comments,$registarion_id));
        }
        catch (\Exception $e)
        {

        }




        return response()->json(['success' => 'Notified', 'id' => $registarion_id],200);
    }

    public  function getGreenEventDetails($id)
    {
        $decrypted = Crypt::decryptString($id);

        $register = GreenRegistration::find($decrypted);

        return response()->json(['register' => $register],200);
    }
}