<?php
/**
 * Created by PhpStorm.
 * User: Omen
 * Date: 6/25/2023
 * Time: 10:39 PM
 */

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class BusinessContactBack extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $first_name;
    public $last_name;
    public $business_name;

    public function __construct($first_name,$last_name,$business_name)
    {
        $this->first_name = $first_name;
        $this->last_name = $last_name;
        $this->business_name = $business_name;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            -> from('waqaramjad04@gmail.com','Business Contact')
            ->cc(['waqaramjad04@gmail.com','nav@thetruckingnetwork.ca'])
            ->greeting('Hi '.$this->first_name.''.$this->last_name)
            ->line('Thanks for your interest in '.$this->business_name)
            ->line('The business will contact you back in next few hours')
            ->line('We appreciate your trust in BusinessPages360');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}