<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'first_name' ,
        'last_name' ,
        'username',
        'role_id' ,
        'company_logo',
        'company_logo_url',
        'company_name',
        'title' ,
        'address_1' ,
        'address_2' ,
        'city' ,
        'city1',
        'state' ,
        'state1',
        'postal_code',
        'country' ,
        'phone_number' ,
        'email' ,
        'is_agree_t_c' ,
        'is_subscribed_to_business_listing',
        'password'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    //business has many offers
    public function packages()
    {
        return $this->belongsToMany('App\Models\Package','user_package')
                    ->withPivot('subscription_date','is_deleted','updated_at');
    }

    public function roles()
    {
        return $this->belongsToMany('App\Models\Role','user_role');
    }
}
