<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Job extends Model
{
        //job has many categories
        public function jobCategories()
        {
           return $this->belongsToMany('App\Models\Category','job_category');
        }
    
        //job has many sub categories
        public function jobSubCategories()
        {
            return $this->belongsToMany('App\Models\SubCategory','job_sub_category');
        }

        //job has many application
        public function jobApplications()
        {
            return $this->hasMany('App\Models\JobApplication');
        }

        //job has many benfits
        public function jobBenefits()
        {
            return $this->belongsToMany('App\Models\Benefit','job_benefit')->withPivot('details');
        }    
}