<?php
/**
 * Created by PhpStorm.
 * User: Omen
 * Date: 12/4/2022
 * Time: 4:48 PM
 */

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BusinessLocation extends Model
{
    use HasFactory;

    //business has many categories
    public function businessLocationSubCategories()
    {
        return $this->belongsToMany('App\Models\SubCategory');
    }

    //business has many office hours
    public function businessLocationOfficeHours()
    {
        return $this->belongsToMany('App\Models\OfficeHour')->withPivot('start_time', 'end_time','is_closed','business_location_office_hour_type');
    }

    //business has many categories
    public function businessLocationAmenities()
    {
        return $this->belongsToMany('App\Models\Amenity','business_location_amenities');
    }

}