<?php
/**
 * Created by PhpStorm.
 * User: Omen
 * Date: 11/10/2022
 * Time: 6:19 PM
 */

namespace App\Http\Controllers;


use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use PDO;

class PaymentController extends Controller
{
    public function getPackages()
 {
     $pdo = DB::connection()->getPdo();

     $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, true);

     $stmt = $pdo->prepare('CALL get_packages()');

     $stmt->execute();

     $packages = $stmt->fetchAll(PDO::FETCH_CLASS, 'stdClass');

     return response()->json(['packages' => $packages],200);
 }
    // call this function to create your client token
    public function generateClientToken() {

     $base = "https://api-m.sandbox.paypal.com/";
      $accessToken =   $this->generateAccessToken();
      $response = Http::withHeaders([
         'Authorization' => 'Bearer '.$accessToken,
         'Accept-Language' => 'en_US',
         'Content-Type' => 'application/json',
         'Accept' => 'application/json'
     ])->asForm()->post($base.'v1/identity/generate-token',[]);

     $data = $response->json();

     return response()->json(['data' => $data],200);
}
    // access token is used to authenticate all REST API requests
    function generateAccessToken() {

         $base = "https://api-m.sandbox.paypal.com/";
         try
         {
             $response =  Http::withBasicAuth('AabVgdOrHAT-MZCylKz5llxmQydeEv_wwX41VhQTf-CgZXhnIOIr-yJ_JRIXyRweOzlmM7i24zYYbiMM',
                 'EA4yOequXMCiTAA1XphT7xbUN0nddA7U9cxnMe4D0OVKy_AFCxI19_n3MbY0zIzlWVhL4DhR1kBJ_Twy')->withHeaders([
                 'Content-Type'=> "application/x-www-form-urlencoded"
             ])->asForm()->post($base.'v1/oauth2/token', [
                 'grant_type' => 'client_credentials'
             ]);
             $data = $response->json();
             return $data['access_token'];
         }
         catch (\Exception $e) {
             dd($e);
         }

    }

    function createOrder(){
        $purchaseAmount = "100.00";
        $purchase_units = array();



        $amount = new \stdClass();
        $amount->currency_code = 'USD';
        $amount->value = $purchaseAmount;

        $purchase_unit = new \stdClass();
        $purchase_unit->amount = $amount;

        $purchase_units [] = (array) $purchase_unit;


        $base = "https://api-m.sandbox.paypal.com/";
        $accessToken = $this->generateAccessToken();
        $url = $base.'v2/checkout/orders';
        $response =  Http::withHeaders([
            'Content-Type'=> "application/json",
            'Authorization' => 'Bearer '.$accessToken,
        ])->post($url, [
            'intent' => 'CAPTURE',
            'purchase_units' => $purchase_units
        ]);
       $data = $response->json();
      return $data['id'];
    }

    function approveOrder()
    {
        $base = "https://api-m.sandbox.paypal.com/";
//        $order_id = $this->createOrder();
        $order_id = '0UF372275E677704K';
        $accessToken = $this->generateAccessToken();
        $url = $base.'checkoutnow';
        $response =  Http::withHeaders([
            'Content-Type'=> "application/json",
            'Authorization' => 'Bearer '.$accessToken,
            'Accept' => 'application/json'
        ])->get($url,[
            'token'=>$order_id
        ]);
        $data = $response->json();
        return $data;
    }

    function getOrderDetails(){
        $base = "https://api-m.sandbox.paypal.com/";
//        $order_id = $this->createOrder();
        $order_id = '0UF372275E677704K';
        $accessToken = $this->generateAccessToken();
        $url = $base.'v2/checkout/orders/'.$order_id;
        $response =  Http::withHeaders([
            'Content-Type'=> "application/json",
            'Authorization' => 'Bearer '.$accessToken,
            'Accept' => 'application/json'
        ])->get($url);
        $data = $response->json();
        return  $data;
    }

    function capturePayment(){
        $base = "https://api-m.sandbox.paypal.com/";
        $order_id = $this->createOrder();
        $accessToken = $this->generateAccessToken();
        $url = $base.'v2/checkout/orders/'.$order_id.'/capture';
        $response =  Http::withHeaders([
            'Content-Type'=> "application/json",
            'Authorization' => 'Bearer '.$accessToken,
        ])->asForm()->post($url);
        $data = $response->json();
        return $data;
    }

    function savePackage(Request $request,$id)
    {
        $user = User::find($id);

        $existing_packages = $user->packages()->get();
        foreach ($existing_packages as $p)
        {
            $p->pivot->is_deleted = 1;
            $p->pivot->updated_at =Carbon::now(config('app.timezone', 'UTC'));

            $p->pivot->save();
        }

        $package = new \stdClass();

        $package->package_id = $request->input('id');
        $package->is_deleted = 0;
        $package->subscription_date =Carbon::now(config('app.timezone', 'UTC'));

        $packages = array();

        $packages [] = (array) $package;

        $user->packages()->attach($packages);

        return response()->json(['success' => 'saved'],200);
    }
}