<?php
/**
 * Created by PhpStorm.
 * User: Omen
 * Date: 7/2/2023
 * Time: 2:17 AM
 */

namespace App\Http\Controllers;


use App\Models\Inventory;
use App\Models\InventoryAttachment;
use App\Models\InventoryItem;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class InventoryController  extends Controller
{
    public function getInventoryMeta($user_id)
    {
        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_inventory_meta(?)');

        $stmt->execute(array($user_id));

        $businesses = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $categories = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        return response()->json(['businesses' => $businesses,
            'categories' => $categories],200);
    }

    public function saveInventory(Request $request,$user_id)
    {
        if($request->input('id') != null)
        {
            $inventory = Inventory::find($request->input('id'));
        }
        else
        {
            $inventory = new Inventory();

        }

        $inventory->inventory_type = $request->input('inventory_type');
        $inventory->no_of_items = $request->input('no_of_items');
        $inventory->business_id = $request->input('business_id');
        $inventory->created_by = $user_id;

        $inventory->save();

        return response()->json(['success' => 'saved',
            'id' => $inventory->id],200);
    }

    public function getInventoryList($user_id)
    {
        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_inventory_list(?)');

        $stmt->execute(array($user_id));

        $inventories = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');


        return response()->json(['inventories' => $inventories],200);
    }

    public function getSingleInventory($id,$user_id)
    {
        $inventory = Inventory::find($id);

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_inventory_meta(?)');

        $stmt->execute(array($user_id));

        $businesses = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $categories = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        return response()->json([
            'businesses' => $businesses,
            'categories' => $categories,
            'inventory' => $inventory],200);
    }

    public function saveInventoryItem(Request $request,$user_id)
    {
        if($request->input('id') != null)
        {
            $inventory_item = InventoryItem::find($request->input('id'));
        }
        else
        {
            $inventory_item = new InventoryItem();

        }

        $inventory_item->application = $request->input('application');
        $inventory_item->axles = $request->input('axles');
        $inventory_item->condition_type = $request->input('condition_type');
        $inventory_item->currency = $request->input('currency');
        $inventory_item->custom_description = $request->input('custom_description');
        $inventory_item->item_price = $request->input('item_price');
        $inventory_item->manufacturer = $request->input('manufacturer');
        $inventory_item->mileage = $request->input('mileage');
        $inventory_item->mileage_units = $request->input('mileage_units');
        $inventory_item->model = $request->input('model');

        $inventory_item->city = $request->input('personal_city');
        $inventory_item->country = $request->input('country');
        $inventory_item->personal_mobile_number = $request->input('personal_mobile_number');
        $inventory_item->state = $request->input('personal_state');

        $inventory_item->engine = $request->input('engine');
        $inventory_item->engine_model = $request->input('engine_model');
        $inventory_item->horsepower = $request->input('horsepower');
        $inventory_item->transmission = $request->input('transmission');
        $inventory_item->sleeper = $request->input('sleeper');
        $inventory_item->ratio = $request->input('ratio');

        $inventory_item->exterior_color = $request->input('exterior_color');
        $inventory_item->exterior_other_color = $request->input('exterior_other_color');
        $inventory_item->interior_color = $request->input('interior_color');
        $inventory_item->interior_other_color = $request->input('interior_other_color');


        $inventory_item->ratio = $request->input('ratio');
        $inventory_item->suspension_make = $request->input('suspension_make');
        $inventory_item->suspension = $request->input('suspension');
        $inventory_item->year =  $request->input('year');
        $inventory_item->inventory_id =  $request->input('inventory_id');

        $inventory_item->city = $request->input('city');
        $inventory_item->state = $request->input('state');
        $inventory_item->country = $request->input('country');
        $inventory_item->address = $request->input('address');
        $inventory_item->personal_first_name = $request->input('personal_first_name');
        $inventory_item->personal_last_name =  $request->input('personal_last_name');
        $inventory_item->personal_email =  $request->input('personal_email');
        $inventory_item->personal_mobile_number =  $request->input('personal_mobile_number');
        $inventory_item->contact_ext =  $request->input('contact_ext');
        $inventory_item->postal_code =  $request->input('postal_code');
        $inventory_item->latitude =  $request->input('latitude');
        $inventory_item->longitude =  $request->input('longitude');


        $inventory_item->trailer_length = $request->input('trailer_length');
        $inventory_item->trailer_width =  $request->input('trailer_width');
        $inventory_item->tires =  $request->input('tires');


        $inventory_item->created_by = $user_id;
        $inventory_item->save();

        $inventory_folder_path = $inventory_item->id.'_'.str_replace('-','_',str_replace(' ','_',$inventory_item->application)).'/';

        $inventory_attachments = $request->input('inventory_attachments');

        if (sizeof($inventory_attachments) > 0) {
            foreach ($inventory_attachments as $d) {

                if($d['is_deleted'] == 1)
                {
                    Storage::disk('local')->delete('public/'.$d['encrypted_name']);

                    $attachment = InventoryAttachment::find($d['id']);
                    $attachment->delete();
                }
                else
                {
                    if($d['is_new'] == 1)
                    {
                        preg_match("/data:image\/(.*?);/", $d['base64_code'], $file_extension) ||
                        preg_match("/data:text\/(.*?);/", $d['base64_code'], $file_extension) ||
                        preg_match("/data:application\/(.*?);/", $d['base64_code'], $file_extension) ||
                        preg_match("/data:video\/(.*?);/", $d['base64_code'], $file_extension);
                        @list($type, $file_data) = explode(';', $d['base64_code']);
                        @list(, $file_data) = explode(',', $file_data);



                        $fileName = 'file_' . time() . '_' . rand(pow(10, 3 - 1), pow(10, 3) - 1) . '.' . $file_extension[1];

                        $folder_path =  'public/uploads/inventoryattachments/' . $inventory_folder_path .'attachments/';



                        Storage::disk('local')->put($folder_path . $fileName, base64_decode($file_data));

                        $fileName = 'uploads/inventoryattachments/' .$inventory_folder_path. 'attachments/'.$fileName;


                        $attachment = new InventoryAttachment();
                        $attachment->original_name = $d['original_name'];
                        $attachment->encrypted_name = $fileName;
                        $attachment->ext = $d['ext'];
                        $attachment->mime_type = $d['mime_type'];
                        $attachment->size = $d['size'];
                        $attachment->attachment_type_id = $d['attachment_type_id'];
                        $attachment->attachment_category_id = $d['attachment_category_id'];
                        $attachment->inventory_item_id = $inventory_item->id;
                        $attachment->created_by = $user_id;

                        $attachment->save();
                    }

                }

            }
        }

        return response()->json(['success' => 'saved',
            'id' => $inventory_item->id],200);
    }

    public function getInventoryItemMeta($inventory_id)
    {
        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_inventory_item_meta(?)');

        $stmt->execute(array($inventory_id));

        $parent_inventory = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $parent_inventory = $parent_inventory[0];

        $stmt->nextRowset();

        $inventory_applications = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $inventory_manufacturers = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $manufacturer_models = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $cities = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $states = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        return response()->json([
            'parent_inventory' => $parent_inventory,
            'inventory_applications' => $inventory_applications,
            'inventory_manufacturers' => $inventory_manufacturers,
            'cities' => $cities,
            'states' => $states,
            'manufacturer_models' => $manufacturer_models
        ],200);
    }


    public function deleteInventory($id)
    {
        $inventory = Inventory::find($id);
        $inventory->delete();

        return response()->json(['Deleted' => 'Deleted Successfully',],200);
    }

    public function getPublicInventoryListing($latitude,$longitude)
    {
        $latitude = $latitude == 'undefined' ? null : $latitude;
        $longitude = $longitude == 'undefined' ? null : $longitude;

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_public_inventory_listing(?,?)');

        $stmt->execute(array($latitude,$longitude));

        $inventory_listing = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        return response()->json([
            'inventory_listing' => $inventory_listing,
        ],200);

    }

    public function getPublicInventoryItems($inventory_id,$latitude,$longitude)
    {
        $latitude = $latitude == 'undefined' ? null : $latitude;
        $longitude = $longitude == 'undefined' ? null : $longitude;

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_public_inventory_items(?,?,?)');

        $stmt->execute(array($inventory_id,$latitude,$longitude));

        $inventory = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');
        $inventory = $inventory[0];

        $stmt->nextRowset();

        $inventory_items = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $inventory_obj = new \stdClass();
        $inventory_obj = $inventory;
        $inventory_obj->inventory_items = $inventory_items;

        return response()->json([
            'inventory' => $inventory_obj,
        ],200);
    }

    public function getPublicInventoryItemDetails($inventory_item_id,$latitude,$longitude)
    {
        $latitude = $latitude == 'undefined' ? null : $latitude;
        $longitude = $longitude == 'undefined' ? null : $longitude;

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_public_inventory_item_details(?,?,?)');

        $stmt->execute(array($inventory_item_id,$latitude,$longitude));

        $inventory = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');
        $inventory = $inventory[0];

        $stmt->nextRowset();

        $inventory_item = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');
        $inventory_item = $inventory_item[0];

        $stmt->nextRowset();

        $inventory_item_attachments = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $related_inventory_items = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $inventory_item_obj = new \stdClass();
        $inventory_item_obj = $inventory_item;
        $inventory_item_obj->inventory_attachments = $inventory_item_attachments;
        $inventory_item_obj->related_inventory_items = $related_inventory_items;

        return response()->json([
            'inventory' => $inventory,
            'inventory_item' => $inventory_item_obj
        ],200);
    }

    public function getInventoryItems($inventory_id)
    {
        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_inventory_items(?)');

        $stmt->execute(array($inventory_id));

        $inventory_items = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        return response()->json([
            'inventory_items' => $inventory_items
        ],200);
    }

    public function getSingleInventoryItems($inventory_item_id)
    {
        $inventory_item = InventoryItem::find($inventory_item_id);

        $inventory_attachments = $inventory_item->inventoryAttachments()->get();

        $pdo = DB::connection()->getPdo();

        $pdo->setAttribute(\PDO::ATTR_EMULATE_PREPARES, true);

        $stmt = $pdo->prepare('CALL get_inventory_item_meta(?)');

        $stmt->execute(array($inventory_item->inventory_id));

        $parent_inventory = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $parent_inventory = $parent_inventory[0];

        $stmt->nextRowset();

        $inventory_applications = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $inventory_manufacturers = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $manufacturer_models = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $cities = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        $stmt->nextRowset();

        $states = $stmt->fetchAll(\PDO::FETCH_CLASS, 'stdClass');

        return response()->json([
            'inventory_item' => $inventory_item,
            'inventory_attachments' => $inventory_attachments,
            'parent_inventory' => $parent_inventory,
            'inventory_applications' => $inventory_applications,
            'inventory_manufacturers' => $inventory_manufacturers,
            'cities' => $cities,
            'states' => $states,
            'manufacturer_models' => $manufacturer_models
        ],200);
    }
}