<?php
/**
 * Created by PhpStorm.
 * User: Omen
 * Date: 11/10/2022
 * Time: 6:19 PM
 */

namespace App\Http\Controllers;


use Illuminate\Support\Facades\Http;

class PaymentController extends Controller
{
    // base URL will need to change for production applications

//
//
//// call this function to create your client token
 public function generateClientToken() {

     $base = "https://api-m.sandbox.paypal.com/";
      $accessToken =   $this->generateAccessToken();
//     $accessToken = 'A21AAI0q76xjMQo4DTaQ4XfqqIDGPNjs4pWc6pFPrCBgHE068rAgg0R3e0OFqXzQR6ccuNnmNuNzpMAKW_4mzrCBPkgVVE_-Q';
     $response = Http::withHeaders([
         'Authorization' => 'Bearer '.$accessToken,
         'Accept-Language' => 'en_US',
         'Content-Type' => 'application/json',
         'Accept' => 'application/json'
     ])->asForm()->post($base.'v1/identity/generate-token',[]);

     $data = $response->json();
     $status = $response->status();
     return response()->json(['data' => $data,
         'status' => $status],200);
}

// access token is used to authenticate all REST API requests
     function generateAccessToken() {

         $base = "https://api-m.sandbox.paypal.com/";
         try
         {
             $response =  Http::withBasicAuth('AabVgdOrHAT-MZCylKz5llxmQydeEv_wwX41VhQTf-CgZXhnIOIr-yJ_JRIXyRweOzlmM7i24zYYbiMM',
                 'EA4yOequXMCiTAA1XphT7xbUN0nddA7U9cxnMe4D0OVKy_AFCxI19_n3MbY0zIzlWVhL4DhR1kBJ_Twy')->withHeaders([
                 'Content-Type'=> "application/x-www-form-urlencoded"
             ])->asForm()->post($base.'v1/oauth2/token', [
                 'grant_type' => 'client_credentials'
             ]);
             $data = $response->json();
             return $data['access_token'];
         }
         catch (\Exception $e) {
             dd($e);
         }

    }

    function createOrder(){
        $purchaseAmount = "100.00";
        $purchase_units = array();



        $amount = new \stdClass();
        $amount->currency_code = 'USD';
        $amount->value = $purchaseAmount;

        $purchase_unit = new \stdClass();
        $purchase_unit->amount = $amount;

        $purchase_units [] = (array) $purchase_unit;


        $base = "https://api-m.sandbox.paypal.com/";
        $accessToken = $this->generateAccessToken();
        $url = $base.'v2/checkout/orders';
        $response =  Http::withHeaders([
            'Content-Type'=> "application/json",
            'Authorization' => 'Bearer '.$accessToken,
        ])->post($url, [
            'intent' => 'CAPTURE',
            'purchase_units' => $purchase_units
        ]);
       $data = $response->json();
      return $data['id'];
    }

    function approveOrder()
    {
        $base = "https://api-m.sandbox.paypal.com/";
//        $order_id = $this->createOrder();
        $order_id = '0UF372275E677704K';
        $accessToken = $this->generateAccessToken();
        $url = $base.'checkoutnow';
        $response =  Http::withHeaders([
            'Content-Type'=> "application/json",
            'Authorization' => 'Bearer '.$accessToken,
            'Accept' => 'application/json'
        ])->get($url,[
            'token'=>$order_id
        ]);
        $data = $response->json();
        return $data;
    }

    function getOrderDetails(){
        $base = "https://api-m.sandbox.paypal.com/";
//        $order_id = $this->createOrder();
        $order_id = '0UF372275E677704K';
        $accessToken = $this->generateAccessToken();
        $url = $base.'v2/checkout/orders/'.$order_id;
        $response =  Http::withHeaders([
            'Content-Type'=> "application/json",
            'Authorization' => 'Bearer '.$accessToken,
            'Accept' => 'application/json'
        ])->get($url);
        $data = $response->json();
        return  $data;
    }

    function capturePayment(){
        $base = "https://api-m.sandbox.paypal.com/";
        $order_id = $this->createOrder();
        $accessToken = $this->generateAccessToken();
        $url = $base.'v2/checkout/orders/'.$order_id.'/capture';
        $response =  Http::withHeaders([
            'Content-Type'=> "application/json",
            'Authorization' => 'Bearer '.$accessToken,
        ])->asForm()->post($url);
        $data = $response->json();
        return $data;
    }
}